/* Copyright (c) 2010 Nordic Semiconductor. All Rights Reserved.
 *
 * The information contained herein is property of Nordic Semiconductor ASA.
 * Terms and conditions of usage are described in detail in NORDIC
 * SEMICONDUCTOR STANDARD SOFTWARE LICENSE AGREEMENT. 
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRANTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 */ 

/** @file
 * @brief Implementation of lib_ir_receive
 */

#ifndef LIB_IR_RECEIVE_H__
#define LIB_IR_RECEIVE_H__

#include <stdint.h>
#include <stdbool.h>
#include "lib_ir_common.h"

#define LIB_IR_LEVEL_HIGH    -1
#define LIB_IR_LEVEL_LOW     1

/** @name   MISC FUNCTIONS  */
//@{
/* Misc function prototypes */

/** Function to initialize the IR receive library.
 *  This function sets default parameters
 *  @param timer_period The period of the timer that is used in s 
 */
void lib_ir_receive_init(uint8_t timer_period);

/** Function that should be called every timer interrupt
 *  This function increment counters and keeps track of the timing when receiving the IR data
 */
void lib_ir_receive_timer_irq_function(void);

/** Function that should be called every edge of the signal from the receiver, both falling and rising
 *  @param level The current level of the signal, HIGH or LOW
 */
void lib_ir_receive_edge_irq_function(int8_t level);

/** Function that is called when a reception is complete
 *  This function must be implemented outside the library
 *  @param sequence The received data sequence
 */
void lib_ir_receive_data_received_callback(uint32_t sequence);

/** Function that is called if an error occurs while receiving the data 
 *  This function must be implemented outside the library
 */
void lib_ir_receive_error_callback(void);

/** @name   OPERATION FUNCTIONS  */
//@{
/* Operation function prototypes */

/** Function to start reception of a command.
 *  @param protocol The protocol that we are expecting
 *  @return The status of the command, TRUE if success, FALSE if fail
 */
bool lib_ir_receive_command(lib_ir_protocol_name_t protocol);

#endif
